<?php
/**
 * Module Name: MyArcadePlugin Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'myarcade_init' ) || function_exists( 'F241D3F7A06D35E769A9D67F9524C4CD1' ) ) :

 //*************** Actions ***************\\
 add_action('myarcade_update_play_points', 'wpachievements_play_game');
 add_action('myarcade_new_score', 'wpachievements_submit_score');
 add_action('myarcade_new_highscore', 'wpachievements_new_highscore');
 add_action('myarcade_new_medal', 'wpachievements_new_medal');
 //*************** Detect playing of a game ***************\\
 function wpachievements_play_game() {
   if( is_user_logged_in() ) {
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'playedgame',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_play_points'),
    ) );     
   }
 }
 //*************** Detect submitting a score ***************\\
 function wpachievements_submit_score() {
   if( is_user_logged_in() ) {
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'scoresubmit',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_score_points'),
    ) );       
   }
 }
 //*************** Detect new highscore ***************\\
 function wpachievements_new_highscore() {
   if( is_user_logged_in() ) {
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'newhighscore',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_highscore_points'),
    ) );     
   }
 }
 //*************** Dectect new medal ***************\\
 function wpachievements_new_medal() {
   if( is_user_logged_in() ) {
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'newmedal',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_medal_points'),
    ) );  
   }
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_map_desc', 10, 4);
 function achievement_map_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'playedgame': { $text = sprintf( _n( 'for playing %s game', 'for playing %s games', $times, 'wpachievements'), $times ); } break;
   case 'newhighscore': { $text = sprintf( _n( 'for getting %s highscore', 'for getting %s highscores', $times, 'wpachievements'), $times ); } break;
   case 'scoresubmit': { $text = sprintf( _n( 'for submitting %s score', 'for submitting %s scores', $times, 'wpachievements'), $times ); } break;
   case 'newmedal': { $text = sprintf( _n( 'for getting %s medal', 'for getting %s medals', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_map_desc', 10, 3);
 function quest_map_desc($text='',$type='',$times=''){
  switch($type){
   case 'playedgame': { $text = sprintf( _n( 'Play %s game', 'Play %s games', $times, 'wpachievements'), $times ); } break;
   case 'newhighscore': { $text = sprintf( _n( 'Get %s highscore', 'Get %s highscores', $times, 'wpachievements'), $times ); } break;
   case 'scoresubmit': { $text = sprintf( _n( 'Submit %s score', 'Submit %s scores', $times, 'wpachievements'), $times ); } break;
   case 'newmedal': { $text = sprintf( _n( 'Get %s medal', 'Get %s medals', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_myarcadeplugin' );
function wpachievements_add_section_myarcadeplugin( $sections ) {
	$sections['myarcadeplugin'] = __( 'MyArcadePlugin', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_map_admin', 10, 3);
function wpachievements_map_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'myarcadeplugin' ) {
    $settings[] = array( 'title' => __( 'MyArcadePlugin', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'MyArcadePlugin_options' );

    $settings[] = array(
            'title'   => __( 'User Playing Games', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user plays a game.', 'wpachievements' ),
            'id'      => $shortname.'_play_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Submitting Scores', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user submits a score.', 'wpachievements' ),
            'id'      => $shortname.'_score_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Getting Highscores', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user gets a highscore.', 'wpachievements' ),
            'id'      => $shortname.'_highscore_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Getting Medals', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user gets a medal.', 'wpachievements' ),
            'id'      => $shortname.'_medal_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] =     array( 'type' => 'sectionend', 'id' => 'MyArcadePlugin_options');

    return $settings;
    /**
	 * If not, return the standard settings
	 **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_map_admin_events', 10);
 function achievement_map_admin_events(){
   echo '<optgroup label="'.__('MyArcadePlugin Events', 'wpachievements').'">
     <option value="playedgame">'.__('The user plays a game', 'wpachievements').'</option>
     <option value="scoresubmit">'.__('The user submits a new score', 'wpachievements').'</option>
     <option value="newhighscore">'.__('The user gets a new highscore', 'wpachievements').'</option>
     <option value="newmedal">'.__('The user gets a new medal', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_map_admin_triggers', 1, 10);
 function achievement_map_admin_triggers($trigger){

   switch($trigger){
     case 'playedgame': { $trigger = __('The user plays a game', 'wpachievements'); } break;
     case 'scoresubmit': { $trigger = __('The user submits a new score', 'wpachievements'); } break;
     case 'newhighscore': { $trigger = __('The user gets a new highscore', 'wpachievements'); } break;
     case 'newmedal': { $trigger = __('The user gets a new medal', 'wpachievements'); } break;
   }

   return $trigger;

 }

/**
 *************************************************
 *    A D D I T I O N A L   F U N C T I O N S    *
 *************************************************
 */
 if ( is_active_widget('', '','mabp_user_login') ) {
  function modify_user_widget() {
    list($lvlstat,$wid) = wpa_ranks_widget();
    echo "<script>
    jQuery(document).ready(function(){
      jQuery('.userinfo').append('".$lvlstat."');
      jQuery('.pb_bar_user_login').animate({width:'".$wid."px'},1500);
    });
    </script>";
  }
  add_action( 'wp_footer', 'modify_user_widget' );
 }
endif;
?>